// priority: 100
onEvent('entity.loot_tables', event => {
    //Add green heart fragments to guardians and elder guardians
    event.modifyEntity('minecraft:guardian', table => {
        table.addPool(pool => {
            pool.rolls = 1
            pool.addEntry({
                "type": "minecraft:item",
                "functions": [{
                    "function": "set_count",
                    "count": {
                        "type": "minecraft:uniform",
                        "min": 0.0,
                        "max": 3.0
                    }
                }, {
                    "function": "minecraft:looting_enchant",
                    "count": 1
                }],
                "name": "kubejsadditions:green_heart_fragment"
            })
        })
    })
    event.modifyEntity('minecraft:elder_guardian', table => {
        table.addPool(pool => {
            pool.rolls = 1
            pool.addEntry({
                "type": "minecraft:item",
                "functions": [{
                    "function": "set_count",
                    "count": {
                        "type": "minecraft:uniform",
                        "min": 3.0,
                        "max": 12.0
                    }
                }, {
                    "function": "minecraft:looting_enchant",
                    "count": 1
                }],
                "name": "kubejsadditions:green_heart_fragment"
            })
        })
    })
})

onEvent('chest.loot_tables', event => {
    //Function to add yellow heart fragments to some chests
    var addYellowFragmentsToChestPool = function (name, chance, min, max) {
        event.modify(name, table => {
            table.addPool(pool => {
                pool.rolls = 1
                pool.bonusRolls = 1
                pool.addCondition({
                    "condition": "minecraft:random_chance",
                    "chance": chance
                })
                pool.addEntry({
                    "type": "minecraft:item",
                    "functions": [{
                        "function": "set_count",
                        "count": {
                            "type": "minecraft:uniform",
                            "min": min,
                            "max": max
                        }
                    }],
                    "name": "kubejsadditions:yellow_heart_fragment"
                })
            })
        })
    }

    //Add yellow heart fragments to chests (and craftable)
    addYellowFragmentsToChestPool('minecraft:simple_dungeon', 0.75, 2.0, 5.1)
    addYellowFragmentsToChestPool('minecraft:desert_pyramid', 0.90, 3.0, 6.5)
    addYellowFragmentsToChestPool('minecraft:jungle_temple', 1.0, 5.6, 9.2) //Very common in jungle temples
    addYellowFragmentsToChestPool('minecraft:shipwreck_supply', 1.0, 8.0, 12.0) //Super common in shipwreck supply chests
    addYellowFragmentsToChestPool('minecraft:shipwreck_treasure', 0.75, 5.0, 7.1)
    addYellowFragmentsToChestPool('minecraft:abandoned_mineshaft', 0.75, 2.0, 5.1)

    //I expect people wanting an easier start if they have the bonus chest, so here you go.
    addYellowFragmentsToChestPool('minecraft:spawn_bonus_chest', 1.0, 18.0, 18.0)
})

onEvent("recipes", (event) => {
    //Add shaped hearts
    event.shaped("bhc:blue_heart", ["FFF", "FFF", "FFF"], {
        F: "kubejsadditions:blue_heart_fragment"
    });
    event.shaped("bhc:red_heart", ["FFF", "FFF", "FFF"], {
        F: "kubejsadditions:red_heart_fragment"
    });
    event.shaped("bhc:green_heart", ["FFF", "FFF", "FFF"], {
        F: "kubejsadditions:green_heart_fragment"
    });
    event.shaped("bhc:yellow_heart", ["FFF", "FFF", "FFF"], {
        F: "kubejsadditions:yellow_heart_fragment"
    });

    //Add the canisters
    event.shapeless('bhc:red_heart_canister', ['bhc:canister', '#forge:slimeballs', 'bhc:red_heart']).id('bhc:red_heart_canister');
    event.shapeless('bhc:red_heart_canister', ['bhc:canister', 'minecraft:paper', 'minecraft:honey_bottle', 'bhc:red_heart']);

    event.shapeless('bhc:blue_heart_canister', ['bhc:canister', '#forge:slimeballs', 'bhc:blue_heart']).id('bhc:blue_heart_canister');
    event.shapeless('bhc:blue_heart_canister', ['bhc:canister', 'minecraft:paper', 'minecraft:honey_bottle', 'bhc:blue_heart']);

    event.shapeless('bhc:green_heart_canister', ['bhc:canister', '#forge:slimeballs', 'bhc:green_heart']).id('bhc:green_heart_canister');
    event.shapeless('bhc:green_heart_canister', ['bhc:canister', 'minecraft:paper', 'minecraft:honey_bottle', 'bhc:green_heart']);

    event.shapeless('bhc:yellow_heart_canister', ['bhc:canister', '#forge:slimeballs', 'bhc:yellow_heart']).id('bhc:yellow_heart_canister');
    event.shapeless('bhc:yellow_heart_canister', ['bhc:canister', 'minecraft:paper', 'minecraft:honey_bottle', 'bhc:yellow_heart']);

    //Add amulet
    event.shaped("bhc:heart_amulet", ["S S", "GFG", " G "], {
        S: "#forge:string",
        F: "#kubejsadditions:heart_fragment",
        G: "#forge:ingots/gold"
    }).id('bhc:heart_amulet');

    //Craftable yellow hearts
    event.shapeless('4x kubejsadditions:yellow_heart_fragment', ['quark:yellow_corundum_cluster']);
})